"use client";
import { useForm } from "react-hook-form";
import { zodResolver } from "@hookform/resolvers/zod";
import { useEffect, useState } from "react";
import Image from "next/image";
import profilePic from "../../../public/assets/profile/empty-classroom.jpg";
// import { getData, putData } from "@/app/request/remotAPIs";
import { toast } from "sonner";
// import { profileSchema, passwordSchema } from "@/app/lib/form-validation/auth/validation";

import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import {
  Sheet,
  SheetClose,
  SheetContent,
  SheetDescription,
  SheetFooter,
  SheetHeader,
  SheetTitle,
  SheetTrigger,
} from "@/components/ui/sheet";
import { Edit } from "lucide-react";

// Statistiques du profil
const stats = [
  { data: "35K", title: "Customers" },
  { data: "10K+", title: "Downloads" },
  { data: "40+", title: "Countries" },
  { data: "30M+", title: "Total revenue" },
  { data: "35K", title: "Customers" },
  { data: "10K+", title: "Downloads" },
];

export default function Profil() {

//   const [user, setUser] = useState(null);
//   const [profileLoading, setProfileLoading] = useState(false);
//   const [passwordLoading, setPasswordLoading] = useState(false);
  
//   // Configuration du formulaire de profil
//   const profileForm = useForm({
//     resolver: zodResolver(profileSchema),
//     defaultValues: {
//       first_name: "",
//       last_name: "",
//       email: "",
//       phone: "",
//     }
//   });

//   // Configuration du formulaire de mot de passe
//   const passwordForm = useForm({
//     resolver: zodResolver(passwordSchema || {
//       current_password: (val) => val && val.length >= 6 || "Le mot de passe actuel est requis",
//       new_password: (val) => val && val.length >= 6 || "Le nouveau mot de passe doit contenir au moins 6 caractères",
//       confirm_password: (val, formValues) => val === formValues.new_password || "Les mots de passe ne correspondent pas"
//     }),
//     defaultValues: {
//       current_password: "",
//       new_password: "",
//       confirm_password: ""
//     }
//   });

//   // Chargement des données utilisateur
//   useEffect(() => {
//     async function fetchUserData() {
//       try {
//         const result = await getData("profile");
//         if (result.response) {
//           // setUser(result.response);
//           console.log(result.response);
          
//           // Mise à jour du formulaire avec les données utilisateur
//           profileForm.reset({
//             first_name: result.response.first_name || "",
//             last_name: result.response.last_name || "",
//             email: result.response.email || "",
//             phone: result.response.phone || "",
//           });
//         }
//       } catch (err) {
//         toast.error("Erreur lors du chargement du profil");
//         console.error(err);
//       }
//     }
    
//     fetchUserData();
//   }, [profileForm]);


//   // Soumission du formulaire de profil
//   const onProfileSubmit = async (data) => {
//     setProfileLoading(true);
//     try {
//       const response = await putData("profile", data);
//       toast.success(response.message || "Profil mis à jour avec succès");
//       setUser(prevUser => ({ ...prevUser, ...data }));
//     } catch (err) {
//       toast.error(err.message || "Erreur lors de la mise à jour du profil");
//     } finally {
//       setProfileLoading(false);
//     }
//   };

//   // Soumission du formulaire de mot de passe
//   const onPasswordSubmit = async (data) => {
//     setPasswordLoading(true);
//     try {
//       const response = await putData("profile/password", {
//         current_password: data.current_password,
//         new_password: data.new_password,
//         confirm_password: data.confirm_password,
//       });

//       toast.success(response.message || "Mot de passe mis à jour avec succès");
//       passwordForm.reset();
      
//       // Option: Déconnexion automatique après changement de mot de passe
//       setTimeout(() => window.location.href = "/", 2000);
      
//     } catch (err) {
//       toast.error(err.message || "Erreur lors du changement de mot de passe");
//     } finally {
//       setPasswordLoading(false);
//     }
//   };

//   // Création d'un composant réutilisable pour les champs de formulaire
//   const FormField = ({ id, label, register, errors, type = "text" }) => (
//     <div className="grid grid-cols-4 items-center gap-4">
//       <Label htmlFor={id} className="text-start">
//         {label}
//       </Label>
//       <div className="col-span-3">
//         <Input id={id} type={type} {...register(id)} />
//         {errors[id] && (
//           <p className="text-red-500 text-sm">
//             {errors[id].message}
//           </p>
//         )}
//       </div>
//     </div>
//   );

  // Création d'un composant pour le bouton de soumission
  const SubmitButton = ({ loading, text }) => (
    <button
      type="submit"
      disabled={loading}
      className={`bg-[#fb923d] text-white ${
        loading ? "opacity-50" : ""
      } py-2 px-4 rounded transition-opacity hover:opacity-90`}
    >
      {loading ? (
        <div className="w-5 h-5 mx-auto border-4 border-t-transparent border-white rounded-full animate-spin"></div>
      ) : (
        text
      )}
    </button>
  );

  return (
    <div>
      <Sheet>
        {/* Bouton d'édition du profil */}
        <SheetTrigger asChild>
          <div className="flex justify-end">
            <Button variant="link" className="text-slate-400 uppercase flex items-center gap-2">
              <Edit size={18} /> Modifier mon profil
            </Button>
          </div>
        </SheetTrigger>

        {/* Contenu du panneau d'édition */}
        <SheetContent className="overflow-y-auto">
          {/* Formulaire de profil */}
          <div className="profile mb-10">
            <SheetHeader>
              <SheetTitle className="uppercase text-[#fb923d]">
                Mon profil
              </SheetTitle>
              <SheetDescription>
                Modifiez votre profil ici. Cliquez sur Enregistrer lorsque vous
                avez terminé.
              </SheetDescription>
            </SheetHeader>

            {/* <form onSubmit={profileForm.handleSubmit(onProfileSubmit)}>
              <div className="grid gap-4 py-4">
                <FormField 
                  id="first_name" 
                  label="Prénom(s)" 
                  register={profileForm.register} 
                  errors={profileForm.formState.errors} 
                />
                
                <FormField 
                  id="last_name" 
                  label="Nom" 
                  register={profileForm.register} 
                  errors={profileForm.formState.errors} 
                />
                
                <FormField 
                  id="email" 
                  label="Email" 
                  register={profileForm.register} 
                  errors={profileForm.formState.errors} 
                />
                
                <FormField 
                  id="phone" 
                  label="Contact" 
                  register={profileForm.register} 
                  errors={profileForm.formState.errors} 
                />

                <SubmitButton loading={profileLoading} text="Mettre à jour" />
              </div>
            </form> */}
          </div>

          {/* Formulaire de changement de mot de passe */}
          <div className="password">
            <SheetHeader>
              <SheetTitle className="uppercase text-[#fb923d]">
                Mot de passe
              </SheetTitle>
              <SheetDescription>
                Modifiez votre mot de passe ici. Après avoir sauvegardé, vous
                serez déconnecté.
              </SheetDescription>
            </SheetHeader>

            {/* <form onSubmit={passwordForm.handleSubmit(onPasswordSubmit)}>
              <div className="grid gap-4 py-4">
                <FormField 
                  id="current_password" 
                  label="Mot de passe actuel" 
                  type="password"
                  register={passwordForm.register} 
                  errors={passwordForm.formState.errors} 
                />
                
                <FormField 
                  id="new_password" 
                  label="Nouveau mot de passe" 
                  type="password"
                  register={passwordForm.register} 
                  errors={passwordForm.formState.errors} 
                />
                
                <FormField 
                  id="confirm_password" 
                  label="Confirmer le mot de passe" 
                  type="password"
                  register={passwordForm.register} 
                  errors={passwordForm.formState.errors} 
                />

                <SubmitButton loading={passwordLoading} text="Mettre à jour mot de passe" />
              </div>
            </form> */}
          </div>

          <SheetFooter>
            <SheetClose asChild>
              <Button variant="outline">Fermer</Button>
            </SheetClose>
          </SheetFooter>
        </SheetContent>
      </Sheet>

      {/* Affichage du profil */}
      <div className="grid min-h-[140px] w-full place-items-center overflow-x-scroll rounded-lg lg:overflow-visible">
        <figure className="relative w-full h-96">
          <Image
            src={profilePic}
            alt="Photo de profil"
            className="object-cover object-center w-full h-full rounded-xl"
          />
          {/* <figcaption className="absolute bottom-8 left-2/4 flex w-[calc(100%-4rem)] -translate-x-2/4 justify-between rounded-xl border border-white bg-white/75 py-2 px-6 shadow-lg shadow-black/5 saturate-200 backdrop-blur-sm">
            <div>
              <h5 className="text-xl font-medium text-slate-800">
                {user?.first_name} {user?.last_name}
              </h5>
              <p className="text-slate-600">
                Créé le : <span>{user?.created_at}</span>
              </p>
            </div>
            <div>
              <h5 className="text-xl font-medium text-slate-800">
                {user?.email}
              </h5>
              <p className="text-slate-600">{user?.phone}</p>
            </div>
          </figcaption> */}
        </figure>
      </div>

      {/* Statistiques */}
      {/* <section className="mt-8">
        <div className="mx-auto px-4 text-gray-600 md:px-8">
          <div className="mt-5">
            <ul className="flex flex-col items-center justify-center gap-y-8 sm:flex-row sm:flex-wrap lg:divide-x">
              {stats.map((item, idx) => (
                <li key={idx} className="text-center px-8 md:px-16">
                  <h4 className="text-4xl text-[#fb923d] font-semibold">
                    {item.data}
                  </h4>
                  <p className="mt-3 font-medium">{item.title}</p>
                </li>
              ))}
            </ul>
          </div>
        </div>
      </section> */}
    </div>
  );
}